# 🧩 LMN Site Monitor

**Versión:** 0.6.4  
**Autor:** [Francisco Moreno](https://fcomoreno.net)  
**Licencia:** GPLv3  
**Compatible con:** PHP 8.3+, WordPress 6.8.3+

Un panel ligero para monitorizar tus sitios webs (HTTP, SSL, latencia y caducidad de certificados), con alertas por email y widget de escritorio.
Acreditado a **Francisco Moreno Sánchez-Aguililla**.

---

### 🧩 Descripción

**LMN Site Monitor** supervisa tus sitios WordPress (HTTP/HTTPS, SSL, latencia) y te avisa si algo falla.  
Ligero, rápido, sin dependencias externas, y con un diseño claro.

- Monitor HTTP/HTTPS y caducidad SSL
- Latencia y estado de respuesta
- Exportar/Importar CSV
- Alertas por email con diseño adaptativo
- Widget de escritorio con límite configurable

### ⚙️ Instalación

1. Sube el ZIP a tu WordPress desde “Plugins > Añadir nuevo”.
2. Activa “LMN Site Monitor”.
3. Añade tus sitios desde el panel “Site Monitor” del menú principal.

---

== Changelog ==

Version: 2025-10-16 - v0.6.3.
Author: Francisco Moreno (fmkr) & Lex – Lúmina Lab
Notes: Eliminación de IDs duplicados y mejoras de accesibilidad.

UI:

- FIX: IDs únicos en formularios (nonces y botones submit).
- FIX: Eliminados avisos en consola por #\_wpnonce y #submit duplicados.
- IMPROVE: Accesibilidad y estructura DOM del panel admin.

Maintenance:

- Bump versión a v0.6.3.

================================
Version: 2025-10-15 - v0.6.2.
Author: Francisco Moreno (fmkr) & Lex – Lúmina Lab
Notes: Markdown seguro en Changelog + badge de versión + cabecera unificada.

UI:

- IMPROVE: Cabecera azul unificada (h2.hndle) con badge v0.6.2.
- ADD: Renderizado Markdown ligero (títulos, listas, **negritas**, `code`, separadores).
- KEEP: Padding y estructura coherente (.postbox.lm-card > h2.hndle + .inside).

Maintenance:

- Bump versión a v0.6.2.

================================
Version: 2025-10-15 - v0.6.1.
Author: Francisco Moreno (fmkr) & Lex – Lúmina Lab
Notes: Pestaña "Changelog" con Markdown ligero y mejoras de legibilidad.

UI:

- NEW: Pestaña “Changelog” con lectura directa de `changelog.txt`.
- IMPROVE: Cuerpo con padding, fondo limpio y mejor ritmo tipográfico.
- IMPROVE: Renderizado Markdown ligero: **negritas**, `code`, títulos (# ## ###) y listas con prefijos destacados (NEW, FIX, IMPROVE…).

Maintenance:

- Bump versión a v0.6.1.

===========================================
Version: 2025-10-14
Author: Francisco Moreno (fmkr) & Lex – Lúmina Lab
Notes: Ajustes SMTP + UI tarjetas + correcciones menores

Functional:

- SMTP operativo: formulario alineado con claves reales (`smtp_*`) y autenticación.
- Conserva la contraseña SMTP si se guarda vacía (no se sobrescribe).
- Compatibilidad con Gmail (contraseñas de aplicación) y Office 365.

UI:

- Listado reemplazado por grid de tarjetas responsive (auto-fit/minmax).
- Estado ‘OK’ (verde texto blanco) y ‘Caído’ (rojo texto blanco).
- Tarjetas de sitios caídos con borde rojo + pulso suave (respeta reduced motion).
- Limpieza de estilos inline → CSS en `assets/admin-theme.css`.

Maintenance:

- Nonces y handlers verificados; sin cambios en cron ni lógica de comprobación.
- # CSV e import/bulk intactos.

2025-10-07 — v0.6.0

- NEW: Importar CSV con el mismo formato que el export (añade URLs sin eliminar las existentes).
- NEW: Acciones masivas en el listado (Eliminar seleccionados) con manejadores estándar de WordPress.
- IMPROVE: UI del listado: checkbox maestro, barra de acciones en lote y confirmaciones.
- IMPROVE: Manejo de errores y mensajes tras importar o aplicar acciones en lote.

2025-10-06 — v0.5.3

- NEW: Exportar CSV desde la sección “Acerca de Site Monitor”.
- NEW: Sección “Acerca de Site Monitor” con métricas rápidas y estado del cron.
- IMPROVE: Limpieza menor en cabeceras y constantes (VERSION).

2025-10-06 — v0.5.2

- NEW: Caja “Acerca de Site Monitor” en la columna derecha del administrador.

2025-10-06 — v0.5.1

- CHANGE: Email HTML claro por defecto + modo oscuro automático con prefers-color-scheme.

2025-10-06 — v0.5.0

- NEW: Email de alerta HTML con badges, tabla de detalles y botones de acción.
- NEW: Preferencia por usuario en el widget (número de sitios a mostrar).
- IMPROVE: UI clásica mejorada (tema claro/oscuro, responsive en tabla y formularios).
- FIX: Contraste de textos en tema oscuro (labels, celdas y descripciones).

2025-10-05 — v0.4.0

- NEW: Página de administración con listado, acciones rápidas y ajustes.
- NEW: Comprobaciones HTTP + caducidad SSL con alertas por email.
- NEW: Cron programable (5 min, 15 min, hora, día) y “forzar comprobación”.
