(function () {
  const cfg = window.LM_MONITOR_SETTINGS || {
    defaultTheme: "system",
    useLocalFont: 1,
    fontsBaseUrl: "",
  };

  // Aplica tema inicial (orden de preferencia: localStorage -> ajuste por defecto -> sistema)
  const rootSel = ".lm-scope";
  const applyTheme = (mode) => {
    document.querySelectorAll(rootSel).forEach((el) => {
      el.classList.remove("lm-dark", "lm-light");
      if (mode === "dark") el.classList.add("lm-dark");
      if (mode === "light") el.classList.add("lm-light"); // clase no usada pero reservada
      // si es system, no añade clase y deja colores por defecto del admin
    });
  };

  const sysPrefersDark = () =>
    window.matchMedia &&
    window.matchMedia("(prefers-color-scheme: dark)").matches;

  let mode =
    localStorage.getItem("lmSiteMonitorTheme") || cfg.defaultTheme || "system";
  if (mode === "system") mode = sysPrefersDark() ? "dark" : "light";
  applyTheme(mode);

  // Escucha cambios del sistema si está en "system" por defecto y no hay localStorage
  if (!localStorage.getItem("lmSiteMonitorTheme")) {
    const mql = window.matchMedia("(prefers-color-scheme: dark)");
    mql.addEventListener &&
      mql.addEventListener("change", (e) => {
        if ((cfg.defaultTheme || "system") === "system")
          applyTheme(e.matches ? "dark" : "light");
      });
  }

  // Toggle botones
  document.addEventListener("click", (e) => {
    const btn = e.target.closest(".lm-theme-btn");
    if (!btn) return;
    const m = btn.getAttribute("data-mode");
    if (m === "system") {
      localStorage.removeItem("lmSiteMonitorTheme");
      applyTheme(sysPrefersDark() ? "dark" : "light");
    } else {
      localStorage.setItem("lmSiteMonitorTheme", m);
      applyTheme(m);
    }
  });

  /*  // Tipografía local opcional (aplicar solo si carga bien)
  if (parseInt(cfg.useLocalFont, 10) === 1) {
    const applyFontClass = () => {
      document
        .querySelectorAll(".lm-scope")
        .forEach((el) => el.classList.add("lm-font"));
    };

    if (document.fonts && document.fonts.load) {
      // Pedimos un peso intermedio del variable; si resuelve, aplicamos clase
      document.fonts
        .load('1rem "LMQuicksandVar"')
        .then(applyFontClass)
        .catch(applyFontClass);
    } else {
      // Fallback navegadores sin Font Loading API
      applyFontClass();
    }
  } */
})();
