<?php
/**
 * Uninstall for LMN Site Monitor
 *
 * @package LMN_Site_Monitor
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

// Options used by the plugin.
$option_keys = array(
    'lm_sites',
    'lm_settings',
    'lm_last_alerts',
    'lmn_ssl_insecure_pings', // opcional si se habilita
);

// Delete options.
foreach ( $option_keys as $key ) {
    if ( get_option( $key, null ) !== null ) {
        delete_option( $key );
    }
}

// Delete user meta for dashboard widget limit.
// Usamos delete_metadata() con $delete_all = true para eliminar todas las entradas de la clave.
delete_metadata( 'user', 0, 'lm_widget_limit', '', true );

// Try to clear typical scheduled hooks (best-effort).
$hooks = array(
    'lmn_site_monitor_cron',
    'site_monitor_cron',
    'lm_site_monitor_cron',
);

foreach ( $hooks as $hook ) {
    while ( $timestamp = wp_next_scheduled( $hook ) ) {
        wp_unschedule_event( $timestamp, $hook );
    }
    wp_clear_scheduled_hook( $hook );
}
